package com.orangemarshall.hudproperty.example;

import com.orangemarshall.hudproperty.base.IBasicRenderer;
import com.orangemarshall.hudproperty.util.ScreenPosition;

import net.minecraft.client.Minecraft;

public class ExampleBasicRenderer implements IBasicRenderer{

	private static int x = 0;
	private static int y = 0; 
	
	/*
	 * HudPropertyAPI.open(new ExampleListener());
	 * ^ to open the gui screen
	 */
	
	@Override
	public void save(ScreenPosition pos) {
		x = pos.getAbsoluteX();
		y = pos.getAbsoluteY();
	}

	@Override
	public ScreenPosition load() {
		return ScreenPosition.newAbsolute(x, y);
	}

	@Override
	public void render(ScreenPosition position) {
		Minecraft.getMinecraft().fontRendererObj.drawString("HELLO WORLD", position.getAbsoluteX(), position.getAbsoluteY(), 0xFFFFFF);
	}

}
